﻿<%@ Page Language="C#" AutoEventWireup="false" CodePage="1200" %>

<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Handel" %>
<%@ Import Namespace="Soneta.Towary" %>
<%@ Import Namespace="Soneta.Magazyny" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>Raport opakowań</title>

    <script runat="server">
        Quantity przychód = new Quantity();
        Quantity rozchód = new Quantity();
        KontrahentOpakowaniaWorker kow = new KontrahentOpakowaniaWorker();
        
        Quantity przychódH = new Quantity();
        Quantity rozchódH = new Quantity();
        KontrahentOpakowaniaWorker kowH = new KontrahentOpakowaniaWorker();

        void dc_ContextLoad( Object sender, EventArgs args )
        {
            if( !dc.Context.Contains( typeof( DokumentyParams ) ) )
                throw new Exception( "Wydruk dostępny tylko dla listy obrotów opakowań kartoteki kontrahenta." );
                
            DokumentyParams pars = dc[ typeof( DokumentyParams ) ] as DokumentyParams;

            HandelModule handelModule = HandelModule.GetInstance( dc.Session );

            SubTable dokumenty = handelModule.DokHandlowe.WgKontrahent[ pars.Dostawca, pars.Magazyn ];
            RowCondition condition = new FieldCondition.In( "Kategoria", KategoriaHandlowa.WydanieOpakowań,
                                                                       KategoriaHandlowa.PrzyjęcieOpakowań,
                                                                       KategoriaHandlowa.KorektaWydaniaOpakowań,
                                                                       KategoriaHandlowa.KorektaPrzyjęciaOpakowań )
                                   & new FieldCondition.Contain( "Data", pars.OkresDat );
            dokumenty = dokumenty[ condition ];

            System.Collections.Generic.List<String> towary = new System.Collections.Generic.List<String>();

            foreach( DokumentHandlowy dokument in dokumenty )
            {
                foreach( PozycjaDokHandlowego pozycja in dokument.Pozycje )
                {
                    if( !towary.Contains( pozycja.ID.ToString() ) )
                        towary.Add( pozycja.ID.ToString() );
                }
            }

            SubTable view = handelModule.PozycjeDokHan.CreateView().SubTable;
            RowCondition cond = towary.Count > 0 ? new FieldCondition.In( "ID", towary.ToArray() ) : new FieldCondition.In( "ID", "-1" );
            view = view[ cond ];
            view.ForceAllRows();

            Grid.DataSource = view;
            Soneta.Business.View view1 = handelModule.PozycjeDokHan.CreateView();

            RowCondition cond1 = new FieldCondition.Equal("Towar.Opakowanie", true);
            cond1 &= new FieldCondition.Equal( "Dokument.Magazyn", pars.Magazyn );
            cond1 &= new FieldCondition.Equal( "Dokument.Kontrahent", pars.Dostawca );
            cond1 &= new FieldCondition.In("Dokument.Kategoria", KategoriaHandlowa.Sprzedaż, KategoriaHandlowa.KorektaSprzedaży,
                                                        KategoriaHandlowa.Zakup, KategoriaHandlowa.KorektaZakupu);
                

            cond1 &= new FieldCondition.Contain( "Dokument.Data", pars.OkresDat );

            RowCondition rcRH = new RowCondition.Exists("Dokument", "RelacjeHandlowe", "Podrzedny", 
                new FieldCondition.In("Nadrzedny.Kategoria", KategoriaHandlowa.WydanieOpakowań, KategoriaHandlowa.PrzyjęcieOpakowań, KategoriaHandlowa.KorektaWydaniaOpakowań, KategoriaHandlowa.KorektaWydaniaOpakowań));
               
            

            view1.Condition = cond1 & rcRH;
            Grid1.DataSource = view1;




        }

        void onBeforeRow( Object sender, RowEventArgs args )
        {
            kow.Pozycja = args.Row as PozycjaDokHandlowego;
            przychód += kow.IlośćPrzychodu;
            rozchód += kow.IlośćRozchodu;
        }

        void onAfterRender( Object sender, EventArgs args )
        {
        }


        
        void onBeforeRow1( Object sender, RowEventArgs args )
        {
            kowH.Pozycja = args.Row as PozycjaDokHandlowego;
            przychódH += kowH.IlośćPrzychodu;
            rozchódH += kowH.IlośćRozchodu;
        }

        void onAfterRender1( Object sender, EventArgs args )
        {
            // PodsumowanieH.EditValue = przychódH - rozchódH;
            Podsumowanie.EditValue = przychód - rozchód - przychódH + rozchódH;  
        }


    </script>

</head>
<body>
    <form id="form1" runat="server">
    <ea:DataContext ID="dc" runat="server" OnContextLoad="dc_ContextLoad"></ea:DataContext>
    <eb:ReportHeader ID="ReportHeader" Title="Raport opakowań - szczegóły|</STRONG>Okres magazynowy:<STRONG> {0}|</STRONG>Kontrahent:<STRONG> {1}"
        runat="server" DataMember0="DokumentyParams.OkresDat" DataMember1="DokumentyParams.Dostawca"></eb:ReportHeader>
		<div style="margin: 15px 0px 5px 0px">
			Pozycje wydań/przyjęć:
		</div>
		<ea:Grid runat="server" RowTypeName="Soneta.Handel.PozycjaDokHandlowego,Soneta.Handel" ID="Grid" OnBeforeRow="onBeforeRow" OnAfterRender="onAfterRender">
			<Columns>
				<ea:GridColumn ID="GridColumn1" Width="4" Align="Right" DataMember="#" Caption="LP." EncodeHTML="True" runat="server"></ea:GridColumn>
				<ea:GridColumn ID="GridColumn2" Width="10" Align="Center" DataMember="Data" Caption="Data" runat="server"></ea:GridColumn> 
				<ea:GridColumn ID="GridColumn3" Width="12" Align="Right" DataMember="Workers.KontrahentOpakowania.IlośćPrzychodu" Caption="Ilość przychodu" Total="Sum"  runat="server"></ea:GridColumn>
				<ea:GridColumn ID="GridColumn4" Width="12" Align="Right" DataMember="Workers.KontrahentOpakowania.IlośćRozchodu" Caption="Ilość rozchodu" Total="Sum" runat="server"></ea:GridColumn> 
				<ea:GridColumn ID="GridColumn5" Align="Left" DataMember="Towar" Caption="Towar" runat="server"></ea:GridColumn> 
				<ea:GridColumn ID="GridColumn7" Width="20" Align="Left" DataMember="Dokument" Caption="Dokument" runat="server"></ea:GridColumn> 
				<ea:GridColumn ID="GridColumn8" Width="14" Align="Right" DataMember="Wartość" Caption="Wartość" runat="server"></ea:GridColumn> 
			</Columns>   	
		</ea:Grid>
		<div style="margin: 15px 0px 5px 0px">
			Pozycje faktur sprzedaży/zakupów (opakowania zafakturowane):
		</div>
		<ea:Grid runat="server" RowTypeName="Soneta.Handel.PozycjaDokHandlowego,Soneta.Handel" ID="Grid1" OnBeforeRow="onBeforeRow1" OnAfterRender="onAfterRender1">
			<Columns>
				<ea:GridColumn ID="GridColumn9" Width="4" Align="Right" DataMember="#" Caption="LP." EncodeHTML="True" runat="server"></ea:GridColumn>
				<ea:GridColumn ID="GridColumn10" Width="10" Align="Center" DataMember="Data" Caption="Data" runat="server"></ea:GridColumn> 
				<ea:GridColumn ID="GridColumn11" Width="12" Align="Right" DataMember="Workers.KontrahentOpakowania.IlośćPrzychodu" Caption="Ilość przychodu" Total="Sum"  runat="server"></ea:GridColumn>
				<ea:GridColumn ID="GridColumn12" Width="12" Align="Right" DataMember="Workers.KontrahentOpakowania.IlośćRozchodu" Caption="Ilość rozchodu" Total="Sum" runat="server"></ea:GridColumn> 
				<ea:GridColumn ID="GridColumn13" Align="Left" DataMember="Towar" Caption="Towar" runat="server"></ea:GridColumn>
				<ea:GridColumn ID="GridColumn15" Width="20" Align="Left" DataMember="Dokument" Caption="Dokument" runat="server"></ea:GridColumn> 
				<ea:GridColumn ID="GridColumn16" Width="14" Align="Right" DataMember="Wartość" Caption="Wartość" runat="server"></ea:GridColumn> 
			</Columns>    
		</ea:Grid>

    <div style="font-size: 18px; margin: 15px 0px 0px 0px">
        Podsumowanie ilości: <ea:DataLabel ID="Podsumowanie" runat="server" />
    </div>

    <eb:ReportFooter id="ReportFooter" runat="server" TheEnd="False"></eb:ReportFooter>
    </form>
</body>
</html>
